/******************************************************
 * ArchC architecture-dependent syscall header file.  *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/

#ifndef _NIOS32_SYSCALL_H_
#define _NIOS32_SYSCALL_H_

#include "nios32_arch.H"
#include "nios32_arch_ref.H"
#include "nios32_parms.H"
#include "ac_syscall.H"

// nios32 system calls.
class nios32_syscall:
 public ac_syscall<nios32_parms::ac_word, nios32_parms::ac_Hword>, public nios32_arch_ref
{
 public:
  nios32_syscall(nios32_arch& ref):
   ac_syscall<nios32_parms::ac_word, nios32_parms::ac_Hword>(ref, nios32_parms::AC_RAMSIZE),
   nios32_arch_ref(ref)
  {
   return;
  }

  void get_buffer(int argn, unsigned char* buf, unsigned int size);
  void set_buffer(int argn, unsigned char* buf, unsigned int size);
  void set_buffer_noinvert(int argn, unsigned char* buf, unsigned int size);
  int get_int(int argn);
  void set_int(int argn, int val);
  void return_from_syscall();
  void set_prog_args(int argc, char** argv);
};

#endif // _NIOS32_SYSCALL_H_ 
